import os

def build_file_tree(path):
    if os.path.isdir(path):
        children = []
        for item in os.listdir(path):
            children.append(build_file_tree(os.path.join(path, item)))
        return {
            'type': 'directory',
            'name': os.path.basename(path),
            'contents': children
        }
    else:
        return {
            'type': 'file',
            'name': os.path.basename(path),
            'size': os.path.getsize(path)
        }

def get_file_count(file_tree):
    # À compléter.
    return 0

def get_size(file_tree):
    # À compléter.
    return 0

if __name__ == "__main__":
    path = input("Entrez le chemin du répertoire à analyser: ")
    tree = build_file_tree(path)
    total_size = get_size(tree)
    total_files = get_file_count(tree)
    print("Taille totale: ", get_size(tree))
    print("Nombre total de fichiers: ", total_files)
    if total_files > 0:
        print("Poids moyen des fichiers: ", total_size / total_files)