from pytamaro import *

def frame(progression, couleur_boule, couleur_sol):
    boule = ellipse(50, 50, couleur_boule)
    hauteur_dessus = 500 * progression
    hauteur_dessous = 500 - hauteur_dessus
    forme = above(rectangle(50, hauteur_dessus, transparent), boule)
    forme = above(forme, rectangle(50, hauteur_dessous, transparent))
    forme = above(forme, rectangle(200, 50, couleur_sol))
    return forme

frames = []
for i in range(0, 101):
    p = (i / 100) ** 2
    frames.append(frame(p, red, blue))

save_animation("rebonds.gif", frames, 20)
