from pytamaro import *

def zone(nom, valeur):
    diametre = (valeur ** 0.5) / 1000 * 30
    back = ellipse(diametre, diametre, black)
    back = overlay(back, rectangle(diametre + 20, diametre, transparent))
    label = text(nom, "Helvetica", 16, white)
    label = above(label, rectangle(0, 10, transparent))
    label = above(label, text(str(valeur), "Helvetica", 12, white))
    return overlay(label, back)

donnees = [
    ("Allemagne", 81174000),
    ("France", 66352469),
    ("Italie", 60795612),
    ("Autriche", 8584926),
    ("Suisse", 8236573)
]

def beside_low(g1, g2):
    g1 = pin(bottom_right, g1)
    g2 = pin(bottom_left, g2)
    return compose(g1, g2)