#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <vector>
#include <cctype> // tolower()

// nombres au hasard
#include <functional> // pour bind()
#include <random>

using namespace std;

// ======================================================================
struct Decos {
  bool fleche;
  
  char boule;  // mettre Sapin::tete si pas de boule
  double proba_boule; // probabilité de voir apparaître une boule sur une ligne du corps
};

// --------------------------------------------------
typedef unsigned int uint; // pour aller plus vite ;-)

typedef uint Trapeze; // le nombre de lignes (avec une convention : on part de 3 et on ajoute 2 à chaque ligne)
// On pourrait aussi adopter la convention que 0 ligne c'est un seul caractère (comme la tête)

/*
Si on veut une convention plus large :
  
struct Trapeze
{
  uint taille_debut;
  uint taille_fin;
};
*/

typedef vector<Trapeze> Corps; // liste de (tailles? --> de trapèzes)

// typedef vector<uint> Pied; // liste de tailles

// Autre modélisation : le pied est rectangle, et le caractère avec lequel il faut le dessiner
struct Pied {
  uint largeur;
  uint hauteur;
  char c;
};

struct Sapin {
  char tete; // ou plus exactement le caractère utilisé pour dessiner le corps
  Corps c;
  Pied p;

  // décoration(s?) // flêche ? boules ?
  Decos deco;

};

// ======================================================================
const Sapin sapin_par_defaut
  { .tete  = '*',
    .c = { 3, 5, 9 },
    .p = { .largeur = 5,
           .hauteur = 3,
           .c = '#' },
    .deco = {
      .fleche = true,
      .boule  = 'O',
      .proba_boule = 0.05
    }
  };

// ======================================================================
// retourne vrai ou faux, au hasard ; retourne vrai avec une probabilité proba_true
bool tirage(double proba_true)
{
  random_device rd;          // utilisé ici pour la graine
  unsigned int graine(rd()); // par exemple, ou sinon de votre choix

  // choix du générateur et initialisation (graine)
  default_random_engine generateur(graine);

  uniform_real_distribution<double> distribution(0.0, 1.0);
  function<double()> draw(bind(distribution, generateur));

  if (draw() < proba_true) return true;
  return false;
}

// ======================================================================
string demander_nom()
{
  cout << "Entrez un nom de fichier où écrire : ";
  string nom;
  cin >> nom; // ou getline() si blanc(s) dans le nom de fichier
  return nom;
}

// ======================================================================
uint centre(Sapin const& tree)
{
  return tree.c.back() + 1;
}

// ======================================================================
// pensez à faire des fonctions outils !
void dessiner_a_la_position(ofstream& file, uint pos, char c, bool with_endl = false)
{
  file << setfill(' ') << setw(pos) << c;
  if (with_endl) file << endl;
}

//----------------------------------------------------------------------
void dessiner_ligne(ofstream& file, uint pos, uint taille, char c,
                    char random = 0, double proba = 0.0)
/* Dessine une ligne de taille fois c, à partir d'une position pos donnée.
   Version avancée : perturbe parfois la ligne avec une caractère de « bruit »
   (utilisé pour dessiner les boules).
*/
{
  if ((random == 0) or (proba <= 0.0) or (proba > 1.0)) {
    // version de base, sans caractère au hasard
    if (taille != 0) {
      dessiner_a_la_position(file, pos, c);
      file << setfill(c) << setw(taille-1) << c;
    }

  } else {
    // quelques de caractères au hasard
    char a_dessiner(c);
    if (tirage(proba)) a_dessiner = random;

    dessiner_a_la_position(file, pos, a_dessiner);

    // on ne peut plus utiliser setfill ici à cause des char au hasard
    for (uint i(2); i <= taille; ++i) {
      a_dessiner = tirage(proba) ? random : c;
      file << a_dessiner;
    }
  }

  file << endl;
}

// ======================================================================
void dessiner_fleche(ofstream& file, uint pos)
{
  dessiner_a_la_position(file, pos, '^', true);
  dessiner_a_la_position(file, pos, '|', true);
}

// ======================================================================
void dessiner_tete(ofstream& file, Sapin const& tree, uint position = 0)
{
  position += centre(tree);

  if (tree.deco.fleche) {
    dessiner_fleche(file, position);
  }

  dessiner_a_la_position(file, position, tree.tete, true);
  // ou alors dessiner un trapeze de taille 0
}

// ======================================================================
void dessiner(ofstream& file, uint pos, Trapeze t, char c,
              char random = 0, double proba = 0.0)
{
  for (uint i(1); i <= t; ++i) {
    dessiner_ligne(file, pos + t - i, 2*i+1, c, random, proba);
  }
}

// ======================================================================
void dessiner_corps(ofstream& file, Sapin const& tree, uint offset = 0)
{
  for (auto partie : tree.c) {
    dessiner(file, offset + centre(tree) - partie, partie, tree.tete,
             tree.deco.boule == tree.tete ? 0 : tree.deco.boule,
             tree.deco.proba_boule);
  }
}

// ======================================================================
void dessiner_pied(ofstream& file, Sapin const& tree, uint position = 0)
{
  position += centre(tree) - tree.p.largeur/2;
  for (uint i(1); i <= tree.p.hauteur; ++i) {
    dessiner_ligne(file, position, tree.p.largeur, tree.p.c);
  }
}

// ======================================================================
void dessiner(ofstream& file, Sapin const& tree, uint offset = 0)
{
  dessiner_tete (file, tree, offset);
  dessiner_corps(file, tree, offset);
  dessiner_pied (file, tree, offset);
}

// ======================================================================
uint demander_ou_placer()
{
  uint retour;
  cout << "À quelle position voulez-vous placer le bord (gauche) du sapin ? ";
  cin >> retour;
  return retour;
}
  
// ======================================================================
Sapin demander_sapin()
{
  cout << "Voulez-vous entrer votre sapin ? [N = sapin par défaut] ";
  string reponse;
  cin >> reponse;

  if (tolower(reponse[0]) == 'n') return sapin_par_defaut;

  Sapin retour{};
  
  cout << "Caractère pour dessiner le corps ? ";
  cin >> retour.tete;
  
  uint nb_parts(0);
  cout << "Combien de trapèzes ? ";
  cin >> nb_parts;
  if (nb_parts > 0) {
    retour.c.assign(nb_parts, 3);
    cout << "Tailles ?" << endl;
    for (uint i(1); i <= nb_parts; ++i) {
      cout << " - taille du trapèze no " << i << " ? ";
      cin >> retour.c[i-1];
    }
  }

  cout << "Caractère pour dessiner le pied ? ";
  cin >> retour.p.c;
  cout << "Largeur du pied ? ";
  cin >> retour.p.largeur;
  cout << "Hauteur du pied ? ";
  cin >> retour.p.hauteur;

  cout << "Décorations [O/N] ? ";
  cin >> reponse;
  if (tolower(reponse[0]) == 'o') {
    cout << "Flêche [O/N] ? ";
    cin >> reponse;
    retour.deco.fleche = (tolower(reponse[0]) == 'o');
    
    cout << "Caractère pour dessiner les boules ('" << retour.tete << "' si pas de boule) ? ";
    cin >> retour.deco.boule;
    if (retour.deco.boule == retour.tete) {
      retour.deco.proba_boule = 0.0;
    } else {
      do {
        cout << "Probabilité de boule par ligne (entre 0 et 1) ? ";
        cin >> retour.deco.proba_boule;
      } while ((retour.deco.proba_boule < 0.0) or (retour.deco.proba_boule > 1.0));
    }
  }

  return retour;
}

// ======================================================================
int main()
{
  ofstream fichier(demander_nom());

  if (not fichier.fail()) {
    dessiner(fichier, demander_sapin(), demander_ou_placer());
    fichier.close();
  }
    
  return 0;
}
