#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <vector>
using namespace std;

// ======================================================================
typedef unsigned int uint; // pour aller plus vite ;-)


typedef uint Trapeze; // le nombre de lignes (avec une convention : on part de 3 et on ajoute 2 à chaque ligne)
// On pourrait aussi adopter la convention que 0 ligne c'est un seul caractère (comme la tête)

/*
Si on veut une convention plus large :
  
struct Trapeze
{
  uint taille_debut;
  uint taille_fin;
};
*/

typedef vector<Trapeze> Corps; // liste de (tailles? --> de trapèzes)

// typedef vector<uint> Pied; // liste de tailles

// Autre modélisation : le pied est rectangle, et le caractère avec lequel il faut le dessiner
struct Pied {
  uint largeur;
  uint hauteur;
  char c;
};

struct Sapin {
  //  bool decoration; // est-il décoré ? // tête ? boules ?
  char tete; // ou plus exactement le caractère utilisé pour dessiner le corps
  Corps c;
  Pied p;
};

// ======================================================================
string demander_nom()
{
  return "sapin.txt"; // version de base pour compiler. À faire : la fonction en entier
}

// ======================================================================
uint centre(Sapin const& tree);

// ======================================================================
// pensez à faire des fonctions outils !
void dessiner_a_la_position(ofstream& file, uint pos, char c)
{
  file << setfill(' ') << setw(pos) << c;
}

void dessiner_ligne(ofstream& file, uint pos, uint taille, char c)
{
  if (taille != 0) {
    dessiner_a_la_position(file, pos, c);
    file << setfill(c) << setw(taille-1) << c;
  }
  file << endl;
}

// ======================================================================
void dessiner_tete(ofstream& file, Sapin const& tree)
{
  dessiner_a_la_position(file, tree.c.back()+1, tree.tete);
  file << endl;
  // ou alors dessiner un trapeze de taille 0
}

// ======================================================================
void dessiner(ofstream& file, uint pos, Trapeze t, char c)
{
  for (uint i(1); i <= t; ++i) {
    dessiner_ligne(file, pos + t - i, 2*i+1, c);
  }
}

// ======================================================================
void dessiner_corps(ofstream& file, Sapin const& tree)
{
  for (auto partie : tree.c) {
    dessiner(file, tree.c.back()+1 - partie, partie, tree.tete);
  }
}

// ======================================================================
void dessiner_pied(ofstream& file, Sapin const& tree)
{
  const uint position(tree.c.back()+1 - tree.p.largeur/2);
  for (uint i(1); i <= tree.p.hauteur; ++i) {
    dessiner_ligne(file, position, tree.p.largeur, tree.p.c);
  }
}

// ======================================================================
void dessiner(ofstream& file, Sapin const& tree)
{
  dessiner_tete (file, tree);
  dessiner_corps(file, tree);
  dessiner_pied (file, tree);
}

// ======================================================================
int main()
{
  ofstream fichier(demander_nom());

  if (not fichier.fail()) {

    // demander_ou_placer(); // on pourrait ajouter ça. Voir version complete
  
    //  dessiner(fichier, demander_sapin()); // on pourrait aussi demander la taille du sapin

    // version de base :
    dessiner(fichier,
             { .tete  = '*',
               .c = { 3, 5, 9 },
               .p = { .largeur = 5,
                      .hauteur = 3,
                      .c = '#' }
             }); 

    fichier.close();
  }
    
  return 0;
}
