#include <iostream>
#include <string>
#include <vector>
using namespace std;

// =========================================================
//struct Personne;

struct Personne {
  string nom;
  //  vector<Personne> /// NON NON NON et NON !
  //  vector<Personne&> /// Utilisation voulue : références ; mais techniquement impossible ; donc :
  // vector<Personne*> amis; /// Utilisez des pointeurs quand vous le DEVEZ : ici nécessaire car vector<> de références impossible

  // de plus nous ne modifions pas nos amis, donc finalement :
  vector<const Personne*> amis; 
};

/* *********************************************************
 * ajoute nouvel_ami aux amis de quidam
 */

// Version 1 (possible mais appel peu sympatique) :
/*
void ajoute_ami(Personne* adresse_nouvel_ami, Personne& quidam)
{ quidam.amis.push_back(adresse_nouvel_ami); }
*/

// Version 2 (FAUSSE !!) :
/*
void ajoute_ami(Personne nouvel_ami, Personne& quidam)
{ quidam.amis.push_back(&nouvel_ami); /// JAMAIS JAMAIS JAMAIS JAMAIS d'adresse de variable LOCALE !!!
*/

// Bonne version :
void ajoute_ami(Personne const& nouvel_ami, Personne& quidam)
{
  /// To do : ne pas ajouter un ami qui existe déjà --> attendre « est_ami() »

  quidam.amis.push_back(&nouvel_ami);
}

/* *********************************************************
 * est-ce que a est ami de b ?
 */
bool est_ami(Personne const& a, Personne const& b)
{
  for (auto ami : b.amis) if (&a == ami) return true;
  return false;
}

/* *********************************************************
 * les amis de mes amis (...de mes amis... ; 
 *   (jusqu')à une distance donnée)
 */
cherche_amis(quidam, distance)
{
}

/* *********************************************************
 * afficher une liste d'amis
 */
affiche(amis)
{
}

// *********************************************************
void test_est_ami(const Personne& p1, const Personne& p2)
{
  cout << p1.nom << ' ';
  if (est_ami(p1, p2)) {
    cout << "est";
  } else {
    cout << "n'est pas";
  }
  cout << " ami de " << p2.nom
       << endl;
}

// *********************************************************
int main()
{
  Personne p1({ "Pierre"  , {} });
  Personne p2({ "Paul"    , {} });
  Personne p3({ "Jacques" , {} });

  // Paul est ami de Pierre : passer p2 ou &p2 ?
  /// VERSION 1 : ajoute_ami( &p2 , p1);
  ajoute_ami(p2 , p1); 

  test_est_ami(p2, p1);
  test_est_ami(p3, p1);

  Personne p4({ "Jean"    , {} });

  ajoute_ami(p3, p1); // Jacques est ami de Pierre
  ajoute_ami(p3, p2); // Jacques est aussi ami de Paul

  ajoute_ami(p4, p3); // Jean est ami de Jacques
  ajoute_ami(p4, p2); // Jean est aussi ami de Paul

  ajoute_ami(p1, p4); // Pierre est ami de Jean
  
  ajoute_ami(p2, p1); /* Paul est à nouveau ami de Pierre : 
                       * pas d''ajout, donc             */

  // Tous les amis de Pierre : Paul, Jacques
  cout << "=== Tous les amis de Pierre :" << endl;
  affiche(cherche_amis(p1, 1));

  // Tous les amis des amis de Pierre : Jacques, Jean
  // Jean ne doit y être qu'une seule fois
  cout << "=== Tous les amis des amis de Pierre :" << endl;
  affiche(cherche_amis(p1, 2));

  /* Tous les amis des amis des amis de Pierre :
   *   Jean, Pierre, ..
   * Pierre lui-même y est, mais ça NE doit PAS boucler
   *   à l'infini (grace à l'argument de distance)...
   */
  cout << "=== Tous les amis des amis des amis de Pierre :"
       << endl;
  affiche(cherche_amis(p1, 3));
  
  return 0;
}
