/* Un exemple de moyenne mobile (discrète) sur une fonction du cours
 * (leçon II.1) :
 *
 *   sin(2*PI*t) + 0.5 * sin(8*PI*t) + 0.1 * sin(64*PI*t)
 *
 */


// depuis C++20 (utilisez -std=c++20 ou plus élevé
#include <numbers>
using namespace std::numbers;

/* SINON (si pas c++20) : décommentez cette partie :

#define _USE_MATH_DEFINES    // pour avoir M_PI
#define pi M_PI
*/

#include <iostream>
#include <cmath> // pour sin()
#include <vector>
using namespace std;

constexpr size_t default_width(3);

// ======================================================================
void affiche_synchro(vector<double> const& v,
                     vector<double> const& w)
{
  size_t offset(0);
  cout << "# signal ; moyenne mobile" << endl;
  if (w.size() < v.size()) {
    offset = (v.size() - w.size()) / 2;
  }
  for (size_t i(0); i < v.size(); ++i) {
    cout << v[i];
    if ((i >= offset) and (i < w.size() + offset))
      cout << '\t' << w[i-offset];
    cout << endl;
  }
}

/* ======================================================================
 * Calcule le signal filtré par moyenne mobile sur fenêtre de taille K.
 */
vector<double> filtre_moyenne_mobile(vector<double> const& X, // signal en entrée
                                     size_t K = default_width)
{
  vector<double> X_chapeau;

  // Proctection : Dans les cas tordus, on retournera un tableau vide.
  if ((K != 0) and (X.size() >= K)) {
    X_chapeau.resize(X.size() + 1 - K);
  
    // Calcul initial (en n = K - 1  -->  X_chapeau[0])
    double somme(0.0);
    for (size_t m(0); m < K; ++m) { // itération pour le calcul de la première somme
      somme += X[m];
    }
    X_chapeau[0] = somme / K;

    // Calcul général
    for (size_t n(K), i(1); n < X.size(); ++n, ++i) {
      somme += X[n] - X[n - K];
      X_chapeau[i] = somme / K;
    }
  }
  
  return X_chapeau;
}

// ======================================================================
// un exemple de signal de la leçon II.1
double signal(double t) {
  return sin(2*pi*t) + 0.5 * sin(8*pi*t) + 0.1 * sin(64*pi*t);
}

// ======================================================================
int main()
{
  constexpr double t_min(0.0); // début du « dessin »
  constexpr double t_max(1.0); // fin   du « dessin »
  constexpr double T_e(0.002); // période d'échantillonnage

  // échantillonnage du signal entre t_min et t_max
  vector<double> signal_echantillonne;
  for (double t(t_min); t <= t_max; t += T_e) {
    signal_echantillonne.push_back( signal(t) );
  }
  
  affiche_synchro(signal_echantillonne,
                  filtre_moyenne_mobile(signal_echantillonne, 20) );

  return 0;
}
