#include <iostream>
#include <vector>
using namespace std;

constexpr size_t K_par_defaut(3);

// ======================================================================
void affiche_synchro(vector<double> const& v,
                     vector<double> const& w)
{
  size_t offset(0);
  cout << "# signal ; moyenne mobile" << endl;
  if (w.size() < v.size()) {
    offset = v.size() - w.size();
    for (size_t i(0); i < offset; ++i) {
      cout << v[i] << endl;
    }
  }
  for (size_t i(offset); i < v.size(); ++i) {
    cout << v[i] << '\t' << w[i-offset] << endl;
  }
}

/* ======================================================================
 * Calcule le signal filtré par moyenne mobile sur fenêtre de taille T_c.
 * Version faite en classe.
 */
vector<double> filtre_moyenne_mobile(vector<double> const& X, size_t K = 3)
{
  vector<double> X_hat; // on peut partir de X_hat vide, et push_back ci-dessous (version 1a)
  // ou alors initialiser directement à la bonne taille avec des 0 (version 1b) :
  // vector<double> X_hat(X.size() - (K-1), 0.0);

  // ici n est indexé sur X_hat ; on peut aussi l'indexer sur X (voir _autre_version ci-dessous)
  for (size_t n(0); n < X.size() - (K-1); ++n) {

    X_hat.push_back(0.0); // version 1a, à supprimer dans version 1b
    
    for (int m(n-K+1); m <= int(n); ++m) { // ATTENTION ! ici m peut être négatif, donc pas size_t :-(
      X_hat[n] += X[m+K-1];
    }

    X_hat[n] /= K;
  }
      
  
  return X_hat;
}

/* ======================================================================
 * Autre version : on indexe ici n sur X au lieu de sur X_hat
 */
vector<double> filtre_moyenne_mobile_autre_version(vector<double> const& X, size_t K = 3)
{
  // il serait préférable de s'assurer que l'on a assez d'éléments :
  if (X.size() < K) return X;
  
  vector<double> X_hat(X.size() - (K-1), 0.0);

  // ici n est indexé sur X (version math, donc de 1 à size() incluse)
  for (size_t n(K); n <= X.size(); ++n) {
    for (size_t m(n-K+1); m <= n; ++m) { // dans cette version m est toujours >= 0, et peut donc rester en size_t
      X_hat[n-K] += X[m-1]; // attention cependant m suit la notation mathématique ici (de 1 à T), l'index est donc m-1
                            // on pourrait aussi décaler dans la boucle : de n-K à n strict : m < n (OU alors décaler celle en n)
    }

    X_hat[n-K] /= K;
  }

  return X_hat;
}

/* ======================================================================
 * Encore une autre version, indexé sur X mais de 0 à size() exclue
 */
vector<double> filtre_moyenne_mobile_V3(vector<double> X, size_t K = 3)
{
  vector<double> X_hat; // vide au départ

  for (size_t n(K-1); n < X.size(); ++n) {
    
    double somme(0.0);
    for (size_t m(n-K+1); m <= n; ++m) {
      somme += X[m];
    }

    somme /= K;
    
    X_hat.push_back(somme);
  }
  
  return X_hat;
}

// ======================================================================
int main()
{
  vector<double> temperatures( { 15.1, 14.8, 13.7, 12.6, 13.8, 14.1,
                                 14.5, 14.8, 15.0, 15.1, 15.5         } );

  affiche_synchro(temperatures, filtre_moyenne_mobile(temperatures) );

  return 0;
}
