#include <iostream>
#include <sstream>

#include "datastruct.h"

using namespace std;

// symboles et type pour codes d'erreurs
enum Erreur_datastruct {LECTURE_LIVREUR,LECTURE_VEHICULE,LECTURE_LIVRAISON};

static void erreur(Erreur_datastruct code);

//~ //-----------------------------------------------------------			
Livreur::Livreur(string n, bool d):nom(n),disp(d) 
{
	// vérifications sur la valeur de chaque attribut ici
	// avec des tests supplémentaires ;
	// en cas de détection d'erreur : affichage de message d'erreur et exit 
}

bool Livreur::lecture(istringstream &data)
{
	if(data >> nom >> disp) // lecture des attributs avec succès
	{
		// vérifications sur la valeur de chaque attribut ici
		// avec les mêmes tests que pour le constructeur ;
		// return false en cas de détection d'erreur sur un attribut
		return true;
	}
	else // impossible de lire ces attributs
		erreur(LECTURE_LIVREUR);
		
	return false;
}			

//-----------------------------------------------------------			
Vehicule::Vehicule(unsigned i, bool d): id(i), disp(d)
{
	// vérifications sur la valeur de chaque attribut ici
}   

bool Vehicule::lecture(istringstream &data)
{
	if(data >> id >> disp)  // lecture des attributs avec succès
	{
		// vérifications sur la valeur de chaque attribut ici
		// avec les mêmes tests que pour le constructeur ;
		// return false en cas de détection d'erreur sur un attribut
		return true;
	}
	else // impossible de lire ces attributs
		erreur(LECTURE_VEHICULE);

	return false;
}

//-----------------------------------------------------------			
Livraison::Livraison(string n, unsigned i):nom(n),id(i)
{
	// vérifications sur la valeur de chaque attribut ici
}

bool Livraison::lecture(istringstream &data)
{
	if(data >> nom >> id)  // lecture des attributs avec succès
	{
		// vérifications sur la valeur de chaque attribut ici
		// avec les mêmes tests que pour le constructeur ;
		// return false en cas de détection d'erreur sur un attribut
		return true;
	}
	else // impossible de lire ces attributs
		erreur(LECTURE_LIVRAISON);

	return false;
}			


// affiche un message d'erreur puis quitte le programme
static void erreur(Erreur_datastruct code)
{
	switch(code)
	{
	case LECTURE_LIVREUR : 	 cout << " lecture impossible livreur \n";  
		break;
	case LECTURE_VEHICULE :  cout << " lecture impossible vehicule \n"; 
		break;
	case LECTURE_LIVRAISON : cout << " lecture impossible livraison \n";
		break;
	default: cout << " erreur inconnue\n";
	}
	// arret d'exécution à commenter si on préfère poursuivre en renvoyant un booléen
	exit(EXIT_FAILURE);
}
